package cn.sinozg.applet.common.annotation;

import cn.sinozg.applet.common.core.base.BaseEntity;
import cn.sinozg.applet.opt.constant.OptLogConstant;
import org.apache.commons.lang3.StringUtils;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 关联关系映射注解
 * @Description
 * @Copyright Copyright (c) 2024
 * @author xieyubin
 * @since 2024-02-27 17:43:53
 */
@Target({ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface OptTie {
    /** 注释，会先取 Schema description的值 */
    String desc() default StringUtils.EMPTY;
    /** 主健 */
    String idName() default OptLogConstant.DEFAULT_ID;
    /** 外健 */
    String foreignName();
    /** 类型 指定entity类型 */
    Class<? extends BaseEntity> clazz();
}
