package cn.sinozg.applet.opt.cache;

import cn.sinozg.applet.opt.module.OptLogCycleInfo;
import cn.sinozg.applet.opt.module.OptLogTableInfo;
import com.alibaba.ttl.TransmittableThreadLocal;

import java.util.List;

/**
 * 修改记录线程池缓存工具
 * @Description
 * @Copyright Copyright (c) 2024
 * @author xieyubin
 * @since 2024-02-27 18:10:28
 */
public class OptLogThreadCache {

    private static final ThreadLocal<OptLogCycleInfo> THREAD_LOCAL = new TransmittableThreadLocal<>();

    /**
     * 获取线程池中缓存的修改记录对象
     *
     * @return 修改记录对象
     */
    public static OptLogCycleInfo get() {
        return THREAD_LOCAL.get();
    }

    /**
     * 缓存修改记录对象到线程池中
     *
     * @param cycleInfo 记录
     */
    public static void set(OptLogCycleInfo cycleInfo) {
        THREAD_LOCAL.set(cycleInfo);
    }

    /**
     * 移除当前线程池变量
     */
    public static void remove() {
        THREAD_LOCAL.remove();
    }

    /**
     * 添加修改记录项
     *
     * @param tableInfo 记录
     */
    public static void adds(List<OptLogTableInfo> tableInfo) {
        get().getItems().addAll(tableInfo);
    }

    /**
     * 获取请求提交ID
     * 同一个请求，traceId一致
     *
     * @return id
     */
    public static String getTraceId() {
        return get().getTraceId();
    }

    /**
     * 线程池中的变量是否为空
     *
     * @return 是否为空
     */
    public static boolean empty() {
        return get() == null || get().getItems() == null;
    }

}
