
package cn.sinozg.applet.opt.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import java.util.List;


/**
 * @Description
 * @Copyright Copyright (c) 2024
 * @author xieyubin
 * @since 2024-02-28 12:34:44
 */
@Data
@Configuration
@ConfigurationProperties(prefix = OptLogProperties.UPDATE_RECORD_PREFIX)
public class OptLogProperties {

    public static final String UPDATE_RECORD_PREFIX = "app.opt-log";

    /** 日志 */
    private boolean dataLog;

    /**
     * 全局包含的表
     */
    private List<String> includeTables;

    /**
     * 全局排除的表
     */
    private List<String> excludeTables;

    /**
     * 全局包含字段集合
     */
    private List<String> includeColumns;

    /**
     * 全局排除字段集合
     */
    private List<String> excludeColumns;
}
