package cn.sinozg.applet.opt.module;


import cn.sinozg.applet.opt.enums.ModeEnum;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.util.List;

/**
 * 表记录修改对象 表维度的数据
 * @Description
 * @Copyright Copyright (c) 2024
 * @author xieyubin
 * @since 2024-02-27 18:08:38
 */
@Data
public class OptLogTableInfo {

    @Schema(description = "主键值")
    private String idValue;

    @Schema(description = "外键值")
    private String foreignId;

    @Schema(description = "表基本信息")
    private OptLogTableDetail tableDetail;

    @Schema(description = "对比信息")
    private List<OptLogDiff> diff;

    @Schema(description = "修改类型")
    private ModeEnum mode;
}
