package cn.sinozg.applet.opt.module;

import cn.sinozg.applet.opt.constant.OptLogConstant;
import lombok.Data;

import java.io.Serializable;
import java.util.Map;

/**
 * 表信息对象 缓存
 * @Description
 * @Copyright Copyright (c) 2024
 * @author xieyubin
 * @since 2024-02-27 17:48:46
 */
@Data
public class OptMapperTable implements Serializable {

    /**
     * 实体
     */
    private Class<?> type;

    /**
     * 实体名称
     */
    private String entityName;

    /**
     * 表名称
     */
    private String tableName;

    /**
     * 表描述
     */
    private String tableDesc;

    /**
     * 主键列名称
     */
    private String idColumnName = OptLogConstant.DEFAULT_ID;

    /**
     * 主键属性名称
     */
    private String idPropertyName = OptLogConstant.DEFAULT_ID;

    /**
     * 所有需要记录的值 属性
     */
    private Map<String, OptMapperColumn> propertyMap;

    /**
     * 是否有字段需要记录
     * 默认记录
     */
    private boolean record = true;

    /** 日志表 非业务 */
    private boolean logTable = false;
}
