package cn.sinozg.applet.opt.module;

import lombok.Getter;
import lombok.Setter;
import org.apache.commons.collections4.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @author xieyubin
 * @Description
 * @Copyright Copyright (c) 2024
 * @since 2024-02-27 19:53
 */
@Getter
@Setter
public class OptTieCache<T> {

    private Class<T> clazz;

    private String desc;

    private boolean array;

    private List<OptTieCache<?>> subs;

    private String foreignKey;

    public static <T> OptTieBuild<T> build(Class<T> clazz){
        OptTieBuild<T> build = new OptTieBuild<>();
        build.clazz(clazz);
        return build;
    }

    public static class OptTieBuild<T> {
        private Class<T> clazz;

        private String desc;
        private boolean array = false;

        private List<OptTieCache<?>> subs;

        private String foreignKey;

        public OptTieCache<T> build(){
            OptTieCache<T> tie = new OptTieCache<>();
            tie.setArray(array);
            tie.setClazz(clazz);
            tie.setDesc(desc);
            tie.setForeignKey(foreignKey);
            tie.setSubs(subs);
            return tie;
        }

        public OptTieBuild(){}
        public OptTieBuild<T> base(Class<T> clazz, String desc){
            this.desc = desc;
            this.clazz = clazz;
            return this;
        }
        public OptTieBuild<T> clazz(Class<T> clazz){
            this.clazz = clazz;
            return this;
        }

        public OptTieBuild<T> desc(String desc){
            this.desc = desc;
            return this;
        }


        public OptTieBuild<T> array(boolean array){
            this.array = array;
            return this;
        }

        public OptTieBuild<T> key(String foreignKey){
            this.foreignKey = foreignKey;
            return this;
        }

        public OptTieBuild<T> sub(OptTieCache<?> sub){
            if (CollectionUtils.isEmpty(subs)) {
                subs = new ArrayList<>();
            }
            subs.add(sub);
            return this;
        }

        public OptTieBuild<T> subs(List<OptTieCache<?>> sub){
            if (CollectionUtils.isEmpty(subs)) {
                subs = new ArrayList<>();
            }
            if (CollectionUtils.isNotEmpty(sub)) {
                subs.addAll(sub);
            }
            return this;
        }
    }
}
