/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.biz.opt.service.impl;

import cn.sinozg.applet.biz.opt.entity.OptLogData;
import cn.sinozg.applet.biz.opt.entity.OptLogTable;
import cn.sinozg.applet.biz.opt.entity.OptLogText;
import cn.sinozg.applet.biz.opt.mapper.OptLogDataMapper;
import cn.sinozg.applet.biz.opt.service.OptLogDataService;
import cn.sinozg.applet.biz.opt.service.OptLogTableService;
import cn.sinozg.applet.biz.opt.service.OptLogTextService;
import cn.sinozg.applet.biz.opt.vo.request.OptLogClearRequest;
import cn.sinozg.applet.biz.opt.vo.request.OptLogDataByBizIdPageRequest;
import cn.sinozg.applet.biz.opt.vo.request.OptLogDataPageRequest;
import cn.sinozg.applet.biz.opt.vo.response.OptLogDataByBizIdPageResponse;
import cn.sinozg.applet.biz.opt.vo.response.OptLogDataPageResponse;
import cn.sinozg.applet.common.core.base.BasePageResponse;
import cn.sinozg.applet.common.core.base.PagingRequest;
import cn.sinozg.applet.common.utils.JsonUtil;
import cn.sinozg.applet.common.utils.PageUtil;
import cn.sinozg.applet.common.utils.PojoUtil;
import cn.sinozg.applet.opt.module.OptLogDiffTable;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import jakarta.annotation.Resource;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OptLogDataServiceImpl
extends ServiceImpl<OptLogDataMapper, OptLogData>
implements OptLogDataService {
    @Resource
    private OptLogDataMapper mapper;
    @Resource
    private OptLogTextService textService;
    @Resource
    private OptLogTableService tableService;

    @Override
    public OptLogDataByBizIdPageResponse logDataDetailById(String id) {
        OptLogDataByBizIdPageRequest params = new OptLogDataByBizIdPageRequest();
        params.setId(id);
        OptLogDataByBizIdPageResponse response = this.mapper.logDataDetailById(params);
        this.convert(response);
        return response;
    }

    @Override
    public BasePageResponse<List<OptLogDataByBizIdPageResponse>> logDataDetailByBizId(PagingRequest page, OptLogDataByBizIdPageRequest params) {
        PageUtil pu = (p, q) -> this.mapper.logDataDetailByBizId((Page<OptLogDataByBizIdPageResponse>)p, (OptLogDataByBizIdPageRequest)q);
        BasePageResponse response = pu.page(page, (Object)params);
        if (CollectionUtils.isNotEmpty((Collection)((Collection)response.getData()))) {
            ((List)response.getData()).forEach(this::convert);
        }
        return response;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public void clear(OptLogClearRequest params) {
        boolean clearAll;
        List<String> logIdList = null;
        boolean bl = clearAll = StringUtils.isAllBlank((CharSequence[])new CharSequence[]{params.getId(), params.getBizId(), params.getBeforeTime()}) && params.isClearAll();
        if (StringUtils.isNotBlank((CharSequence)params.getBizId())) {
            logIdList = this.mapper.idListInfoByBizId(params);
        } else if (clearAll || !StringUtils.isAllBlank((CharSequence[])new CharSequence[]{params.getBeforeTime(), params.getId()})) {
            logIdList = this.mapper.idListInfo(params);
        }
        if (CollectionUtils.isEmpty(logIdList)) {
            return;
        }
        List list = PojoUtil.batchList(logIdList, Function.identity());
        for (List ids : list) {
            this.removeBatchByIds(ids);
            this.textService.remove((Wrapper)new LambdaQueryWrapper().in(OptLogText::getLogId, (Collection)ids));
            this.tableService.remove((Wrapper)new LambdaQueryWrapper().in(OptLogTable::getLogId, (Collection)ids));
        }
    }

    @Override
    public BasePageResponse<List<OptLogDataPageResponse>> pageInfo(PagingRequest page, OptLogDataPageRequest params) {
        PageUtil pu = (p, q) -> this.mapper.pageInfo((Page<OptLogDataPageResponse>)p, (OptLogDataPageRequest)q);
        return pu.page(page, (Object)params);
    }

    private void convert(OptLogDataByBizIdPageResponse p) {
        if (p != null && StringUtils.isNotBlank((CharSequence)p.getJsonDiff())) {
            p.setDiff((OptLogDiffTable)JsonUtil.toPojo((String)p.getJsonDiff(), OptLogDiffTable.class));
        }
    }
}

