
/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.opt.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import java.util.List;


/**
 * @Description
 * @Copyright Copyright (c) 2024
 * @author xieyubin
 * @since 2024-02-28 12:34:44
 */
@Data
@Configuration
@ConfigurationProperties(prefix = OptLogProperties.UPDATE_RECORD_PREFIX)
public class OptLogProperties {

    public static final String UPDATE_RECORD_PREFIX = "app.opt-log";

    /** 日志 */
    private boolean dataLog;

    /**
     * 全局包含的表
     */
    private List<String> includeTables;

    /**
     * 全局排除的表
     */
    private List<String> excludeTables;

    /**
     * 全局包含字段集合
     */
    private List<String> includeColumns;

    /**
     * 全局排除字段集合
     */
    private List<String> excludeColumns;
}
