/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.opt.constant;

import cn.sinozg.applet.common.utils.PojoUtil;

import java.util.List;

/**
 * 修改记录常量
 * @Description
 * @Copyright Copyright (c) 2024
 * @author xieyubin
 * @since 2024-02-28 21:00:19
 */
public interface OptLogConstant {

    String DELEGATE_MAPPED_STATEMENT = "delegate.mappedStatement";

    String DELEGATE_BOUND_SQL = "delegate.boundSql";

    String H_TARGET = "h.target";

    /** 默认id */
    String DEFAULT_ID = "id";

    List<String> DEFAULT_EXCLUDE_TABLE = PojoUtil.arrayToList("sys_opt_log_data", "sys_opt_log_table", "sys_opt_log_text");

    List<String> DEFAULT_EXCLUDE_FIELDS = PojoUtil.arrayToList("serialVersionUID", "tenantId", "remark", "createdBy", "createdTime", "updatedBy", "updatedTime");
}
