/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.opt.module;


import cn.sinozg.applet.opt.enums.ModeEnum;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.util.List;

/**
 * 表记录修改对象 表维度的数据
 * @Description
 * @Copyright Copyright (c) 2024
 * @author xieyubin
 * @since 2024-02-27 18:08:38
 */
@Data
public class OptLogTableInfo {

    @Schema(description = "主键值")
    private String idValue;

    @Schema(description = "外键值")
    private String foreignId;

    @Schema(description = "表基本信息")
    private OptLogTableDetail tableDetail;

    @Schema(description = "对比信息")
    private List<OptLogDiff> diff;

    @Schema(description = "修改类型")
    private ModeEnum mode;
}
