/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.opt.module;

import cn.sinozg.applet.biz.opt.entity.OptLogTable;
import cn.sinozg.applet.common.utils.SnowFlake;
import lombok.Getter;
import lombok.Setter;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

/**
 * 解析过程中的需要的参数 返回参数
 * @author xieyubin
 * @Description
 * @Copyright Copyright (c) 2024
 * @since 2024-03-01 11:44
 */
@Getter
@Setter
public class AnalysisMiddleware {

    /** log id */
    private String logId;
    /** 按照类型分类的所有修改数据 */
    private Map<Class<?>, List<OptLogTableInfo>> map;
    /** 主表类型 */
    private Class<?> mainClazz;
    /** 修改信息 */
    private OptLogDiffTable diff;
    /** 表信息 */
    private List<OptLogTable> tables;
    /** 函数 构造 OptLogTable */
    private Function<OptLogTableInfo, OptLogTable> fun;

    public AnalysisMiddleware(Map<Class<?>, List<OptLogTableInfo>> map){
        this.map = map;
        this.logId = SnowFlake.genId();
        this.tables = new ArrayList<>();
    }

    public void addTable (OptLogTableInfo tableInfo) {
        if (fun != null) {
            OptLogTable entity = fun.apply(tableInfo);
            tables.add(entity);
        }
    }
}
