/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.opt.module;

import cn.sinozg.applet.opt.constant.OptLogConstant;
import lombok.Data;

import java.io.Serializable;
import java.util.Map;

/**
 * 表信息对象 缓存
 * @Description
 * @Copyright Copyright (c) 2024
 * @author xieyubin
 * @since 2024-02-27 17:48:46
 */
@Data
public class OptMapperTable implements Serializable {

    /**
     * 实体
     */
    private Class<?> type;

    /**
     * 实体名称
     */
    private String entityName;

    /**
     * 表名称
     */
    private String tableName;

    /**
     * 表描述
     */
    private String tableDesc;

    /**
     * 主键列名称
     */
    private String idColumnName = OptLogConstant.DEFAULT_ID;

    /**
     * 主键属性名称
     */
    private String idPropertyName = OptLogConstant.DEFAULT_ID;

    /**
     * 所有需要记录的值 属性
     */
    private Map<String, OptMapperColumn> propertyMap;

    /**
     * 是否有字段需要记录
     * 默认记录
     */
    private boolean record = true;

    /** 日志表 非业务 */
    private boolean logTable = false;
}
