/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.opt.service;

import cn.sinozg.applet.common.core.model.LoginUserVo;
import cn.sinozg.applet.opt.module.OptLogCycleInfo;

/**
 * @author xieyubin
 * @Description
 * @Copyright Copyright (c) 2024
 * @since 2024-02-28 18:10
 */
public interface OptLogService {

    /**
     * aop 保存
     * @param token token
     * @param user 用户
     * @param cycleInfo 数据
     * @param e 异常
     * @param jsonResult 结果
     */
    void saveLog (String token, LoginUserVo user, OptLogCycleInfo cycleInfo, Exception e, Object jsonResult);
}
