/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.biz.opt.vo.response;

import cn.sinozg.applet.common.utils.DateUtil;
import cn.sinozg.applet.opt.module.OptLogDiffTable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
* 操作、数据日志记录表 分页返回参数
* @Description
* @Copyright Copyright (c) 2024
* @author xieyubin
* @since 2024-02-28 18:03:49
*/
@Data
public class OptLogDataByBizIdPageResponse implements Serializable {

    private static final long serialVersionUID = 1L;
    /** 日志主键 */
    @Schema(description = "日志主键")
    private String logId;

    /** 差异Json信息 */
    @JsonIgnore
    private String jsonDiff;

    @Schema(description = "差异信息")
    private OptLogDiffTable diff;

    @Schema(description = "创建时间")
    @JsonFormat(pattern = DateUtil.YYYY_MM_DD_HH_MM_SS)
    private LocalDateTime createdTime;
}
