/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.opt.module;

import cn.sinozg.applet.opt.constant.OptLogConstant;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

/**
 * 表详情 一次执行不会修改的信息
 * @author xieyubin
 * @Description
 * @Copyright Copyright (c) 2024
 * @since 2024-02-27 21:02
 */
@Data
public class OptLogTableDetail {

    @Schema(description = "全局号")
    private String traceId;

    @Schema(description = "请求号")
    private String methodId;

    @Schema(description = "表名称")
    private String tableName;

    @Schema(description = "表注释")
    private String tableDesc;

    @Schema(description = "实体类型")
    private Class<?> clazz;

    @Schema(description = "主键")
    private String idName = OptLogConstant.DEFAULT_ID;

    @Schema(description = "外键")
    private String foreignIdName;
}
