/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.opt.module;

import lombok.Getter;
import lombok.Setter;
import org.apache.commons.collections4.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @author xieyubin
 * @Description
 * @Copyright Copyright (c) 2024
 * @since 2024-02-27 19:53
 */
@Getter
@Setter
public class OptTieCache<T> {

    private Class<T> clazz;

    private String desc;

    private boolean array;

    private List<OptTieCache<?>> subs;

    private String foreignKey;

    public static <T> OptTieBuild<T> build(Class<T> clazz){
        OptTieBuild<T> build = new OptTieBuild<>();
        return build.clazz(clazz);
    }

    public static class OptTieBuild<T> {
        private Class<T> clazz;

        private String desc;
        private boolean array = false;

        private List<OptTieCache<?>> subs;

        private String foreignKey;

        public OptTieCache<T> build(){
            OptTieCache<T> tie = new OptTieCache<>();
            tie.setArray(array);
            tie.setClazz(clazz);
            tie.setDesc(desc);
            tie.setForeignKey(foreignKey);
            tie.setSubs(subs);
            return tie;
        }

        public OptTieBuild(){}
        public OptTieBuild<T> base(Class<T> clazz, String desc){
            this.desc = desc;
            this.clazz = clazz;
            return this;
        }
        public OptTieBuild<T> clazz(Class<T> clazz){
            this.clazz = clazz;
            return this;
        }

        public OptTieBuild<T> desc(String desc){
            this.desc = desc;
            return this;
        }


        public OptTieBuild<T> array(boolean array){
            this.array = array;
            return this;
        }

        public OptTieBuild<T> key(String foreignKey){
            this.foreignKey = foreignKey;
            return this;
        }

        public OptTieBuild<T> sub(OptTieCache<?> sub){
            if (CollectionUtils.isEmpty(subs)) {
                subs = new ArrayList<>();
            }
            subs.add(sub);
            return this;
        }

        public OptTieBuild<T> subs(List<OptTieCache<?>> sub){
            if (CollectionUtils.isEmpty(subs)) {
                subs = new ArrayList<>();
            }
            if (CollectionUtils.isNotEmpty(sub)) {
                subs.addAll(sub);
            }
            return this;
        }
    }
}
