/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.biz.opt.service.impl;

import cn.sinozg.applet.biz.opt.entity.OptLogData;
import cn.sinozg.applet.biz.opt.entity.OptLogTable;
import cn.sinozg.applet.biz.opt.entity.OptLogText;
import cn.sinozg.applet.biz.opt.service.OptLogDataService;
import cn.sinozg.applet.biz.opt.service.OptLogTableService;
import cn.sinozg.applet.biz.opt.service.OptLogTextService;
import cn.sinozg.applet.common.core.model.LoginUserVo;
import cn.sinozg.applet.common.holder.UserContextHolder;
import cn.sinozg.applet.common.utils.JsonUtil;
import cn.sinozg.applet.common.utils.OsUtil;
import cn.sinozg.applet.common.utils.PojoUtil;
import cn.sinozg.applet.opt.module.AnalysisMiddleware;
import cn.sinozg.applet.opt.module.OptLogCycleInfo;
import cn.sinozg.applet.opt.module.OptLogMain;
import cn.sinozg.applet.opt.module.OptLogTableDetail;
import cn.sinozg.applet.opt.module.OptLogTableInfo;
import cn.sinozg.applet.opt.service.OptLogService;
import cn.sinozg.applet.opt.util.OptUtil;
import jakarta.annotation.Resource;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OptLogServiceImpl
implements OptLogService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OptLogServiceImpl.class);
    @Resource
    private OptLogTextService textService;
    @Resource
    private OptLogDataService logDataService;
    @Resource
    private OptLogTableService logTableService;

    @Override
    @Async
    @Transactional(rollbackFor={Throwable.class})
    public void saveLog(String token, LoginUserVo user, OptLogCycleInfo cycleInfo, Exception e, Object jsonResult) {
        OptLogMain main = cycleInfo.getMain();
        OptLogData logData = (OptLogData)((Object)PojoUtil.copyBean((Object)main, OptLogData.class));
        logData.setTraceId(cycleInfo.getTraceId());
        logData.setOptLocation(OsUtil.realAddressByIp((String)logData.getOptIp()));
        OptLogText logText = new OptLogText();
        if (e != null) {
            logData.setDataStatus("01");
            logText.setErrorMsg(OptUtil.substring(e.getMessage()));
        } else {
            logData.setDataStatus("00");
        }
        if (main.isSaveParams()) {
            logText.setJsonParam(main.getJsonParam());
            logText.setJsonResult(OptUtil.substring(jsonResult));
        }
        List<OptLogTableInfo> list = cycleInfo.getItems();
        List<OptLogTable> tables = null;
        if (e == null && CollectionUtils.isNotEmpty(list)) {
            Map map = PojoUtil.groupMap(list, c -> c.getTableDetail().getClazz());
            AnalysisMiddleware mom = new AnalysisMiddleware(map);
            String logId = mom.getLogId();
            logData.setId(logId);
            logText.setLogId(logId);
            String jsonAllDiff = OptUtil.allDiffJson(mom);
            logText.setJsonAllDiff(jsonAllDiff);
            mom.setFun(t -> this.initTableInfo(logId, (OptLogTableInfo)t));
            OptUtil.diffWithDependency(mom, main.getTie());
            if (mom.getDiff() != null) {
                logText.setJsonDiff(JsonUtil.toJson((Object)mom.getDiff()));
            }
            tables = mom.getTables();
        }
        if (user != null) {
            UserContextHolder.setInfo((String)user.getId(), (String)token, (String)user.getTenantId());
            logData.setOptName(user.getNickName());
            logData.setDeptName(user.getDeptName());
        }
        if (CollectionUtils.isNotEmpty(tables)) {
            this.logTableService.saveBatch(tables);
        }
        this.logDataService.save((Object)logData);
        if (!StringUtils.isAllBlank((CharSequence[])new CharSequence[]{logText.getErrorMsg(), logText.getJsonParam(), logText.getJsonAllDiff()})) {
            logText.setLogId(logData.getId());
            this.textService.save((Object)logText);
        }
        if (user != null) {
            UserContextHolder.clear();
        }
    }

    private OptLogTable initTableInfo(String logId, OptLogTableInfo t) {
        OptLogTableDetail detail = t.getTableDetail();
        OptLogTable logTable = new OptLogTable();
        logTable.setIdValue(t.getIdValue());
        logTable.setLogId(logId);
        logTable.setIdName(detail.getIdName());
        logTable.setForeignKey(t.getForeignId());
        logTable.setForeignKeyName(detail.getForeignIdName());
        logTable.setTabName(detail.getTableName());
        logTable.setMethodId(detail.getMethodId());
        logTable.setTableDesc(detail.getTableDesc());
        logTable.setDiffMode(t.getMode().getCode());
        logTable.setJsonDiff(JsonUtil.toJson(t.getDiff()));
        return logTable;
    }
}

