/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.biz.opt.entity;

import cn.sinozg.applet.common.core.base.BaseEntity;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
* 数据日志操作表记录表
* @Description
* @Copyright Copyright (c) 2024
* @author xieyubin
* @since 2024-03-01 11:30:04
*/
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("sys_opt_log_table")
@Schema(name = "OptLogTable", description = "数据日志操作表记录")
public class OptLogTable extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /** 主键id */
    @Schema(description = "主键id")
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private String id;


    /** 日志id */
    @Schema(description = "日志id")
    @TableField("log_id")
    private String logId;


    /** id值 */
    @Schema(description = "id值")
    @TableField("id_value")
    private String idValue;


    /** id对应的字段 */
    @Schema(description = "id对应的字段")
    @TableField("id_name")
    private String idName;


    /** 外键id值 */
    @Schema(description = "外键id值")
    @TableField("foreign_key")
    private String foreignKey;


    /** 外键字段 */
    @Schema(description = "外键字段")
    @TableField("foreign_key_name")
    private String foreignKeyName;


    /** 表名称 */
    @Schema(description = "表名称")
    @TableField("tab_name")
    private String tabName;


    /** 方法ID */
    @Schema(description = "方法ID")
    @TableField("method_id")
    private String methodId;


    /** 表描述 */
    @Schema(description = "表描述")
    @TableField("table_desc")
    private String tableDesc;


    /** 修改类型 */
    @Schema(description = "修改类型")
    @TableField("diff_mode")
    private String diffMode;


    /** 对比信息 */
    @Schema(description = "对比信息")
    @TableField("json_diff")
    private String jsonDiff;

}
