/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.biz.opt.vo.request;

import cn.sinozg.applet.common.utils.DateUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.time.LocalDateTime;
import java.time.LocalTime;

/**
* 删除记录
* @Description
* @Copyright Copyright (c) 2024
* @author xieyubin
* @since 2024-02-28 18:03:49
*/
@Data
public class OptLogClearRequest {

    @Schema(description = "日志id")
    private String id;

    @Schema(description = "业务id")
    private String bizId;

    @Schema(description = "删除这个日期之前的所有数据 yyyy-MM-dd")
    private String beforeTime;

    @JsonIgnore
    private LocalDateTime bendt;

    @Schema(description = "其他条件不传，此参数生效")
    private boolean clearAll;

    public LocalDateTime getBendt() {
        if (StringUtils.isNotBlank(beforeTime)) {
            return DateUtil.parseDate(beforeTime).atTime(LocalTime.MAX);
        }
        return bendt;
    }
}
