/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.opt.config;

import cn.sinozg.applet.common.aspectj.OptLogDataAspect;
import cn.sinozg.applet.common.interceptor.OptLogMybatisInterceptor;
import cn.sinozg.applet.common.service.FrameworkAuthService;
import cn.sinozg.applet.opt.mark.OptLogMarker;
import cn.sinozg.applet.opt.service.OptLogService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

/**
 * @author xieyubin
 * @Description
 * @Copyright Copyright (c) 2024
 * @since 2024-01-15 18:42
 */
@Slf4j
@Configuration
@ConditionalOnBean(OptLogMarker.class)
public class OptLogAutoConfiguration {
    @Bean
    public OptLogDataAspect optLogDataAspect(OptLogProperties optLogProperties, OptLogService optLogService, FrameworkAuthService authService){
        log.info("启动 日志监控。。。");
        return new OptLogDataAspect(optLogProperties, optLogService, authService);
    }

    @Bean
    @Order(2)
    @ConditionalOnProperty(name = OptLogProperties.UPDATE_RECORD_PREFIX + ".data-log", havingValue = "true")
    public OptLogMybatisInterceptor updateRecordMybatisInterceptor (OptLogProperties optLogProperties){
        log.info("启动 日志数据监控。。。*******");
        return new OptLogMybatisInterceptor(optLogProperties);
    }
}
