/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.opt.module;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

/**
 * 操作日志和数据日志基本信息
 * 对应主表的信息
 * @author xieyubin
 * @Description
 * @Copyright Copyright (c) 2024
 * @since 2024-02-27 21:02
 */
@Data
public class OptLogMain {

    @Schema(description = "模块")
    private String moduleName;

    @Schema(description = "模块标题")
    private String title;

    @Schema(description = "方法名称")
    private String methodName;

    @Schema(description = "业务类型;00其它 01新增 02修改 03删除")
    private String businessType;

    @Schema(description = "操作类别;00其它 01后台用户 02手机端用户")
    private String optType;

    @Schema(description = "请求URL")
    private String optUrl;

    @Schema(description = "请求方式")
    private String requestMethod;

    @Schema(description = "保存请求参数")
    private boolean saveParams;

    @Schema(description = "映射关系")
    private Class<?> tie;

    @Schema(description = "主机地址")
    private String optIp;

    @Schema(description = "操作地点")
    private String optLocation;

    @Schema(description = "请求参数")
    private String jsonParam;

    @Schema(description = "返回参数")
    private String jsonResult;

    @Schema(description = "错误消息")
    private String errorMsg;
}
