/*
 * Copyright (C) 2020-2025, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.oss.service;


import cn.sinozg.applet.oss.model.FileUploadParams;
import cn.sinozg.applet.oss.model.FileUploadResult;
import org.apache.commons.lang3.tuple.Pair;

import java.io.OutputStream;
import java.util.List;

/**
 * 文件存储接口，按照默认配置即可立即使用<p/>
 * 如果一个服务里面需要实现多个服务商，自定义配置后，注入对应的客户端bean和Service实现即可
 * @Description
 * @Copyright Copyright (c) 2025
 * @author xieyubin
 * @since 2025-07-20 15:12:51
 */
public interface FileStoreService<T> {

    /**
     * 上传文件到oss
     * @param params 参数
     * @return 返回的信息
     */
    FileUploadResult uploadOss(FileUploadParams params);

    /**
     * 通过预签名的方式上传或者下载文件
     * @param key key
     * @param upload 是否上传
     * @return key 地址
     */
    Pair<String, String> createPreSignedUrl(String key, boolean upload);


    /**
     * 大文件处理
     * @return 大文件桶
     */
    String largeBucket();
    /**
     * 删除文件
     * @param bucketName 桶名称
     * @param list id
     */
    void deleteFiles (String bucketName, List<String> list);

    /**
     * 下载文件
     * @param os 流
     * @param bucketName 桶
     * @param key key值
     */
    void download(OutputStream os, String bucketName, String key);

    /**
     * 获取文件的扩展名
     * @param orgName 原始名称
     * @param contentType contentType
     * @param allowedExtension 支持的扩展名称
     * @return 文件扩展名
     */
    String fileExtension(String orgName, String contentType, String[] allowedExtension);

    /**
     * 获取客户端
     * @return 客户端
     */
    T client();
}
