/*
 * Copyright (C) 2020-2025, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.oss.service.impl;

import cn.sinozg.applet.common.exception.CavException;
import cn.sinozg.applet.common.properties.OssValue;
import cn.sinozg.applet.common.utils.JsonUtil;
import cn.sinozg.applet.common.utils.PojoUtil;
import cn.sinozg.applet.oss.clients.QnClient;
import com.qiniu.http.Response;
import com.qiniu.storage.BucketManager;
import com.qiniu.storage.UploadManager;
import com.qiniu.storage.model.BatchStatus;
import com.qiniu.storage.model.DefaultPutRet;
import com.qiniu.util.Auth;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * @author xieyubin
 * @Description
 * @Copyright Copyright (c) 2025
 * @since 2025-07-20 21:41
 */
public class FileStoreQnServiceImpl extends FileStoreBaseService<QnClient> {

    private final QnClient qnClient;

    private static final Logger log = LoggerFactory.getLogger(FileStoreQnServiceImpl.class);

    public FileStoreQnServiceImpl(OssValue oss, QnClient qnClient) {
        super(oss);
        this.qnClient = qnClient;
        setClient(qnClient);
    }

    @Override
    public String upload(byte[] bs, String bucketName, String key, String contentType) throws Exception {
        try (ByteArrayInputStream bis = new ByteArrayInputStream(bs)){
            UploadManager uploadManager = qnClient.getUploadManager();
            String token = qnClient.getAuth().uploadToken(bucketName, key);
            Response response = uploadManager.put(bis, key, token, null, contentType);
            DefaultPutRet ret = JsonUtil.toPojo(response.bodyString(), DefaultPutRet.class);
            if (ret != null) {
                return ret.hash;
            } else {
                log.error("上传文件错误：{}", response.bodyString());
            }
            return null;
        }
    }

    @Override
    public Collection<?> deletes(String bucketName, List<String> list) throws Exception {
        BucketManager manager = qnClient.getBucketManager();
        BucketManager.BatchOperations batchOperations = new BucketManager.BatchOperations();
        batchOperations.addDeleteOp(bucketName, PojoUtil.toArray(list, String.class));
        Response response = manager.batch(batchOperations);
        BatchStatus[] statuses = response.jsonToObject(BatchStatus[].class);
        List<Boolean> result = new ArrayList<>();
        for (BatchStatus status : statuses) {
            if (status.code == 200){
                result.add(true);
            } else {
              log.error("删除文件失败，");
            }
        }
        return result;
    }

    /**
     * 七牛的是拿到token。无法拿到连接
     * @param key key
     * @param upload 是否上传
     * @return token 或地址
     * @throws Exception 异常
     */
    @Override
    public String preSignedUrl(String key, boolean upload) throws Exception {
        Auth auth = qnClient.getAuth();
        long expires = signedExp() * 60L;
        if (upload) {
            // 可选策略：限制上传文件大小、类型等
            return auth.uploadToken(largeBucket(), key, expires, null);
        }
        return auth.privateDownloadUrl(preSignedBaseUrl() + key, expires);
    }

    @Override
    public InputStream download(String bucketName, String key) throws Exception {
        throw new CavException("BIZ000100109");
    }
}
