/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.oss.clients;

import cn.sinozg.applet.common.properties.OssValue;
import com.qiniu.http.Client;
import com.qiniu.storage.BucketManager;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.Region;
import com.qiniu.storage.UploadManager;
import com.qiniu.util.Auth;
import java.io.Closeable;
import java.io.IOException;
import java.util.Objects;

public class QnClient
implements Closeable {
    private final OssValue oss;
    private volatile Auth auth;
    private volatile Client client;
    private volatile Configuration configuration;
    private volatile BucketManager bucketManager;
    private volatile UploadManager uploadManager;
    private final Object lock = new Object();
    private volatile boolean closed = false;

    public QnClient(OssValue oss) {
        this.oss = Objects.requireNonNull(oss);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Auth getAuth() {
        if (this.auth == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.auth == null) {
                    this.auth = Auth.create((String)this.oss.getAccessKey(), (String)this.oss.getSecretKey());
                }
            }
        }
        return this.auth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Client getClient() {
        if (this.client == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.client == null) {
                    this.client = new Client(this.getConfiguration());
                }
            }
        }
        return this.client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration getConfiguration() {
        if (this.configuration == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.configuration == null) {
                    this.configuration = Configuration.create((Region)Region.createWithRegionId((String)this.oss.getRegion()));
                }
            }
        }
        return this.configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BucketManager getBucketManager() {
        if (this.bucketManager == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.bucketManager == null) {
                    this.bucketManager = new BucketManager(this.getAuth(), this.getConfiguration(), this.getClient());
                }
            }
        }
        return this.bucketManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UploadManager getUploadManager() {
        if (this.uploadManager == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.uploadManager == null) {
                    this.uploadManager = new UploadManager(this.getConfiguration());
                }
            }
        }
        return this.uploadManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.auth = null;
            this.configuration = null;
            this.bucketManager = null;
            this.uploadManager = null;
            this.client = null;
        }
    }
}

