/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.oss.config;

import cn.sinozg.applet.common.properties.AppValue;
import cn.sinozg.applet.common.properties.OssValue;
import cn.sinozg.applet.oss.service.FileStoreService;
import cn.sinozg.applet.oss.service.impl.FileStoreS3ServiceImpl;
import jakarta.annotation.Resource;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProviderChain;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.presigner.S3Presigner;

@Configuration
@ConditionalOnProperty(name={"app.oss.type"}, havingValue="s3")
public class OssAmazonConfig {
    @Resource
    private AppValue appValue;
    private static final Logger log = LoggerFactory.getLogger(OssAmazonConfig.class);

    @Lazy
    @Bean(name={"s3Client"}, destroyMethod="close")
    public S3Client s3Client() {
        return OssAmazonConfig.s3Client(this.appValue.getOss());
    }

    @Lazy
    @Bean(destroyMethod="close")
    public S3Presigner s3Presigner() {
        return OssAmazonConfig.s3Presigner(this.appValue.getOss());
    }

    @Lazy
    @Bean(name={"s3StoreService"})
    public FileStoreService<S3Client> amazonStoreService(S3Client s3Client, S3Presigner s3Presigner) {
        return new FileStoreS3ServiceImpl(this.appValue.getOss(), s3Client, s3Presigner);
    }

    public static S3Client s3Client(OssValue oss) {
        S3ClientBuilder builder = (S3ClientBuilder)((S3ClientBuilder)S3Client.builder().credentialsProvider((AwsCredentialsProvider)AwsCredentialsProviderChain.builder().addCredentialsProvider(OssAmazonConfig.credentialsProvider(oss)).build())).region(Region.of((String)oss.getRegion()));
        if (StringUtils.isNotBlank((CharSequence)oss.getProxyUrl())) {
            OssAmazonConfig.proxy(builder, oss);
        }
        return (S3Client)builder.build();
    }

    public static S3Presigner s3Presigner(OssValue oss) {
        return S3Presigner.builder().region(Region.of((String)oss.getRegion())).credentialsProvider(OssAmazonConfig.credentialsProvider(oss)).build();
    }

    private static AwsCredentialsProvider credentialsProvider(OssValue oss) {
        return () -> AwsBasicCredentials.create((String)oss.getAccessKey(), (String)oss.getSecretKey());
    }

    private static void proxy(S3ClientBuilder builder, OssValue oss) {
        log.error("user Proxy ..... ");
        builder.httpClientBuilder((SdkHttpClient.Builder)ApacheHttpClient.builder().proxyConfiguration((ProxyConfiguration)ProxyConfiguration.builder().endpoint(URI.create(oss.getProxyUrl())).build()));
    }
}

