/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.oss.config;

import cn.sinozg.applet.common.properties.AppValue;
import cn.sinozg.applet.common.properties.OssValue;
import cn.sinozg.applet.oss.service.FileStoreService;
import cn.sinozg.applet.oss.service.impl.FileStoreMinioServiceImpl;
import io.minio.MinioClient;
import jakarta.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration
@ConditionalOnProperty(name={"app.oss.type"}, havingValue="minio")
public class OssMinioConfig {
    @Resource
    private AppValue appValue;

    @Lazy
    @Bean(name={"minioClient"}, destroyMethod="close")
    public MinioClient minioClient() {
        return OssMinioConfig.minioClient(this.appValue.getOss());
    }

    @Lazy
    @Bean(name={"minioStoreService"})
    public FileStoreService<MinioClient> minioStoreService(MinioClient minioClient) {
        return new FileStoreMinioServiceImpl(this.appValue.getOss(), minioClient);
    }

    public static MinioClient minioClient(OssValue oss) {
        return MinioClient.builder().endpoint(oss.getEndpoint()).credentials(oss.getAccessKey(), oss.getSecretKey()).build();
    }
}

