/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.oss.service.impl;

import cn.sinozg.applet.common.exception.CavException;
import cn.sinozg.applet.common.properties.OssValue;
import cn.sinozg.applet.common.utils.FileUtil;
import cn.sinozg.applet.common.utils.SnowFlake;
import cn.sinozg.applet.oss.model.FileUploadParams;
import cn.sinozg.applet.oss.model.FileUploadResult;
import cn.sinozg.applet.oss.service.FileStoreService;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.Collection;
import java.util.List;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public abstract class FileStoreBaseService<T>
implements FileStoreService<T> {
    private final OssValue oss;
    private T client;
    private static final Logger log = LoggerFactory.getLogger(FileStoreBaseService.class);

    public FileStoreBaseService(OssValue oss) {
        this.oss = oss;
    }

    public abstract String upload(byte[] var1, String var2, String var3, String var4) throws Exception;

    public abstract Collection<?> deletes(String var1, List<String> var2) throws Exception;

    public abstract String preSignedUrl(String var1, boolean var2) throws Exception;

    public abstract InputStream download(String var1, String var2) throws Exception;

    @Override
    public FileUploadResult uploadOss(FileUploadParams params) {
        String md5;
        MultipartFile file = params.getFile();
        String orgName = file.getOriginalFilename();
        String extName = this.checkFileInfo(file, orgName, params.getMaxSize(), params.getAllowedExtension());
        String fileId = SnowFlake.genId();
        Object ossKey = fileId;
        if (!params.isKeyEqId()) {
            ossKey = SnowFlake.genId();
        }
        String fileName = fileId + "." + extName.toLowerCase();
        String bucketName = params.getBucketName();
        if (StringUtils.isBlank((CharSequence)bucketName)) {
            bucketName = this.oss.getBucketName();
        }
        if (params.isShow()) {
            ossKey = (String)ossKey + "." + extName.toLowerCase();
        }
        if (StringUtils.isNotBlank((CharSequence)params.getKeyPrefix())) {
            ossKey = params.getKeyPrefix() + (String)ossKey;
        }
        String contentType = FileUtil.fileType((String)file.getOriginalFilename());
        String sha256 = null;
        try (InputStream is = file.getInputStream();
             ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            int bytesRead;
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            int cacheLength = 8192;
            byte[] buffer = new byte[cacheLength];
            while ((bytesRead = is.read(buffer)) != -1) {
                bos.write(buffer, 0, bytesRead);
                if (!params.isSha()) continue;
                digest.update(buffer, 0, bytesRead);
            }
            md5 = this.upload(bos.toByteArray(), bucketName, (String)ossKey, contentType);
            if (params.isSha()) {
                sha256 = Hex.encodeHexString((byte[])digest.digest());
            }
            if (StringUtils.isBlank((CharSequence)md5)) {
                throw new CavException("BIZ000100104");
            }
        }
        catch (Exception e) {
            log.error("\u4e0a\u4f20\u6587\u4ef6\u81f3OSS\u9519\u8bef", (Throwable)e);
            throw new CavException("BIZ000100104");
        }
        FileUploadResult result = new FileUploadResult(bucketName, (String)ossKey, md5);
        result.setSha256(sha256);
        result.setSize(file.getSize());
        result.setId(fileId);
        result.setExtName(extName);
        result.setOrgName(orgName);
        result.setFileName(fileName);
        return result;
    }

    @Override
    public String largeBucket() {
        String bucketName = this.oss.getLargeBucket();
        if (StringUtils.isBlank((CharSequence)bucketName)) {
            bucketName = this.oss.getBucketName();
        }
        return bucketName;
    }

    @Override
    public Pair<String, String> createPreSignedUrl(String key, boolean upload) {
        String string = key = upload ? SnowFlake.genId() : key;
        if (StringUtils.isBlank((CharSequence)key)) {
            throw new CavException("BIZ000100108");
        }
        try {
            String url = this.preSignedUrl(key, upload);
            if (StringUtils.isBlank((CharSequence)url)) {
                throw new CavException("BIZ000100105");
            }
            return Pair.of((Object)key, (Object)url);
        }
        catch (Exception e) {
            log.error("\u521b\u5efa\u9884\u7b7e\u540d\u5931\u8d25\uff01", (Throwable)e);
            throw new CavException("BIZ000100105");
        }
    }

    @Override
    public void deleteFiles(String bucketName, List<String> list) {
        try {
            Collection<?> result = this.deletes(bucketName, list);
            if (CollectionUtils.isNotEmpty(result)) {
                log.info("\u5220\u9664\u6210\u529f\u6570\u91cf:{}", (Object)result.size());
            }
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u6587\u4ef6\u9519\u8bef\uff01", (Throwable)e);
            throw new CavException("BIZ000100106", e);
        }
    }

    @Override
    public void download(OutputStream os, String bucketName, String key) {
        try (InputStream fis = this.download(bucketName, key);){
            fis.transferTo(os);
        }
        catch (Exception e) {
            log.error("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25\uff01", (Throwable)e);
            throw new CavException("BIZ000100107");
        }
    }

    @Override
    public String fileExtension(String orgName, String contentType, String[] allowedExtension) {
        if (StringUtils.isBlank((CharSequence)orgName) || orgName.length() > 100) {
            throw new CavException("BIZ000100101", new Object[]{100});
        }
        String extension = FilenameUtils.getExtension((String)orgName);
        if (StringUtils.isEmpty((CharSequence)extension) && StringUtils.isNotBlank((CharSequence)contentType)) {
            extension = StringUtils.substringAfterLast((String)contentType, (String)"/");
        }
        if (allowedExtension != null && !Strings.CI.equalsAny((CharSequence)extension, (CharSequence[])allowedExtension)) {
            throw new CavException("BIZ000100102", new Object[]{extension});
        }
        return StringUtils.lowerCase((String)extension);
    }

    @Override
    public T client() {
        return this.client;
    }

    protected void setClient(T client) {
        this.client = client;
    }

    protected int signedExp() {
        Integer exp = this.oss.getSignedExp();
        if (exp == null) {
            exp = 30;
        }
        return exp;
    }

    protected String preSignedBaseUrl() {
        String baseUrl = this.oss.getLargeUrl();
        if (StringUtils.isBlank((CharSequence)baseUrl)) {
            baseUrl = this.oss.getUrl();
        }
        return baseUrl;
    }

    private String checkFileInfo(MultipartFile file, String orgName, long maxSize, String[] allowedExtension) {
        long size = file.getSize();
        if (size > maxSize) {
            throw new CavException("BIZ000100103", new Object[]{maxSize / 1024L / 1024L});
        }
        return this.fileExtension(orgName, file.getContentType(), allowedExtension);
    }
}

