/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.oss.service.impl;

import cn.sinozg.applet.common.properties.OssValue;
import cn.sinozg.applet.common.utils.PojoUtil;
import cn.sinozg.applet.oss.service.impl.FileStoreBaseService;
import io.minio.GetObjectArgs;
import io.minio.GetPresignedObjectUrlArgs;
import io.minio.MinioClient;
import io.minio.ObjectWriteResponse;
import io.minio.PutObjectArgs;
import io.minio.RemoveObjectsArgs;
import io.minio.Result;
import io.minio.http.Method;
import io.minio.messages.DeleteError;
import io.minio.messages.DeleteObject;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileStoreMinioServiceImpl
extends FileStoreBaseService<MinioClient> {
    private static final Logger log = LoggerFactory.getLogger(FileStoreMinioServiceImpl.class);
    private final MinioClient minioClient;

    public FileStoreMinioServiceImpl(OssValue oss, MinioClient minioClient) {
        super(oss);
        this.minioClient = minioClient;
        this.setClient(minioClient);
    }

    @Override
    public String upload(byte[] bs, String bucketName, String key, String contentType) throws Exception {
        try (ByteArrayInputStream bis = new ByteArrayInputStream(bs);){
            ObjectWriteResponse response = this.minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(bucketName)).object(key)).contentType(contentType).stream((InputStream)bis, (long)bis.available(), -1L).build());
            String string = response.etag();
            return string;
        }
    }

    @Override
    public String preSignedUrl(String key, boolean upload) throws Exception {
        GetPresignedObjectUrlArgs params = (GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().bucket(this.largeBucket())).expiry(this.signedExp(), TimeUnit.MINUTES).method(upload ? Method.PUT : Method.GET).object(key)).build();
        return this.minioClient.getPresignedObjectUrl(params);
    }

    @Override
    public Collection<?> deletes(String bucketName, List<String> list) throws Exception {
        List dos = PojoUtil.toList(list, DeleteObject::new);
        Iterable results = this.minioClient.removeObjects((RemoveObjectsArgs)((RemoveObjectsArgs.Builder)RemoveObjectsArgs.builder().bucket(bucketName)).objects((Iterable)dos).build());
        ArrayList<Boolean> result = new ArrayList<Boolean>();
        for (Result r : results) {
            try {
                r.get();
                result.add(true);
            }
            catch (Exception e) {
                DeleteError de = (DeleteError)r.get();
                log.error("minio \u6587\u4ef6\u5220\u9664\u5931\u8d25{}", (Object)de.message());
            }
        }
        return result;
    }

    @Override
    public FilterInputStream download(String bucketName, String key) throws Exception {
        GetObjectArgs params = (GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucketName)).object(key)).build();
        return this.minioClient.getObject(params);
    }
}

