/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.oss.service.impl;

import cn.sinozg.applet.common.exception.CavException;
import cn.sinozg.applet.common.properties.OssValue;
import cn.sinozg.applet.common.utils.JsonUtil;
import cn.sinozg.applet.common.utils.PojoUtil;
import cn.sinozg.applet.oss.clients.QnClient;
import cn.sinozg.applet.oss.service.impl.FileStoreBaseService;
import com.qiniu.http.Response;
import com.qiniu.storage.BucketManager;
import com.qiniu.storage.UploadManager;
import com.qiniu.storage.model.BatchStatus;
import com.qiniu.storage.model.DefaultPutRet;
import com.qiniu.util.Auth;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileStoreQnServiceImpl
extends FileStoreBaseService<QnClient> {
    private final QnClient qnClient;
    private static final Logger log = LoggerFactory.getLogger(FileStoreQnServiceImpl.class);

    public FileStoreQnServiceImpl(OssValue oss, QnClient qnClient) {
        super(oss);
        this.qnClient = qnClient;
        this.setClient(qnClient);
    }

    @Override
    public String upload(byte[] bs, String bucketName, String key, String contentType) throws Exception {
        try (ByteArrayInputStream bis = new ByteArrayInputStream(bs);){
            UploadManager uploadManager = this.qnClient.getUploadManager();
            String token = this.qnClient.getAuth().uploadToken(bucketName, key);
            Response response = uploadManager.put((InputStream)bis, key, token, null, contentType);
            DefaultPutRet ret = (DefaultPutRet)JsonUtil.toPojo((String)response.bodyString(), DefaultPutRet.class);
            if (ret != null) {
                String string = ret.hash;
                return string;
            }
            log.error("\u4e0a\u4f20\u6587\u4ef6\u9519\u8bef\uff1a{}", (Object)response.bodyString());
            String string = null;
            return string;
        }
    }

    @Override
    public Collection<?> deletes(String bucketName, List<String> list) throws Exception {
        BucketManager manager = this.qnClient.getBucketManager();
        BucketManager.BatchOperations batchOperations = new BucketManager.BatchOperations();
        batchOperations.addDeleteOp(bucketName, (String[])PojoUtil.toArray(list, String.class));
        Response response = manager.batch(batchOperations);
        BatchStatus[] statuses = (BatchStatus[])response.jsonToObject(BatchStatus[].class);
        ArrayList<Boolean> result = new ArrayList<Boolean>();
        for (BatchStatus status : statuses) {
            if (status.code == 200) {
                result.add(true);
                continue;
            }
            log.error("\u5220\u9664\u6587\u4ef6\u5931\u8d25\uff0c");
        }
        return result;
    }

    @Override
    public String preSignedUrl(String key, boolean upload) throws Exception {
        Auth auth = this.qnClient.getAuth();
        long expires = (long)this.signedExp() * 60L;
        if (upload) {
            return auth.uploadToken(this.largeBucket(), key, expires, null);
        }
        return auth.privateDownloadUrl(this.preSignedBaseUrl() + key, expires);
    }

    @Override
    public InputStream download(String bucketName, String key) throws Exception {
        throw new CavException("BIZ000100109");
    }
}

