/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.oss.service.impl;

import cn.sinozg.applet.common.properties.OssValue;
import cn.sinozg.applet.oss.service.impl.FileStoreBaseService;
import java.io.InputStream;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.RegExUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.awscore.presigner.PresignedRequest;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.core.sync.ResponseTransformer;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.Delete;
import software.amazon.awssdk.services.s3.model.DeleteObjectsRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectsResponse;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.ObjectIdentifier;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectResponse;
import software.amazon.awssdk.services.s3.presigner.S3Presigner;
import software.amazon.awssdk.services.s3.presigner.model.GetObjectPresignRequest;
import software.amazon.awssdk.services.s3.presigner.model.PutObjectPresignRequest;

public class FileStoreS3ServiceImpl
extends FileStoreBaseService<S3Client> {
    private static final Logger log = LoggerFactory.getLogger(FileStoreS3ServiceImpl.class);
    private final S3Client s3Client;
    private final S3Presigner s3Presigner;

    public FileStoreS3ServiceImpl(OssValue oss, S3Client s3Client, S3Presigner s3Presigner) {
        super(oss);
        this.s3Client = s3Client;
        this.s3Presigner = s3Presigner;
    }

    @Override
    public String upload(byte[] bs, String bucketName, String key, String contentType) throws Exception {
        PutObjectRequest request = (PutObjectRequest)PutObjectRequest.builder().bucket(bucketName).contentType(contentType).key(key).build();
        PutObjectResponse response = this.s3Client.putObject(request, RequestBody.fromBytes((byte[])bs));
        String md5 = response.eTag();
        return RegExUtils.replaceAll((String)md5, (String)"\"", (String)"");
    }

    @Override
    public String preSignedUrl(String key, boolean upload) throws Exception {
        PresignedRequest request = upload ? this.putUrl(key) : this.getUrl(key);
        if (request != null) {
            return request.url().toExternalForm();
        }
        return null;
    }

    @Override
    public Collection<?> deletes(String bucketName, List<String> list) throws Exception {
        ArrayList<ObjectIdentifier> keys = new ArrayList<ObjectIdentifier>();
        for (String key : list) {
            keys.add((ObjectIdentifier)ObjectIdentifier.builder().key(key).build());
        }
        DeleteObjectsRequest request = (DeleteObjectsRequest)DeleteObjectsRequest.builder().bucket(bucketName).delete((Delete)Delete.builder().objects(keys).build()).build();
        DeleteObjectsResponse response = this.s3Client.deleteObjects(request);
        return response.deleted();
    }

    @Override
    public InputStream download(String bucketName, String key) throws Exception {
        GetObjectRequest request = (GetObjectRequest)GetObjectRequest.builder().bucket(bucketName).key(key).build();
        return (InputStream)this.s3Client.getObject(request, ResponseTransformer.toInputStream());
    }

    private PresignedRequest getUrl(String key) {
        GetObjectRequest gutRequest = (GetObjectRequest)GetObjectRequest.builder().bucket(this.largeBucket()).key(key).build();
        GetObjectPresignRequest request = GetObjectPresignRequest.builder().signatureDuration(Duration.ofMinutes(this.signedExp())).getObjectRequest(gutRequest).build();
        return this.s3Presigner.presignGetObject(request);
    }

    private PresignedRequest putUrl(String key) {
        PutObjectRequest putRequest = (PutObjectRequest)PutObjectRequest.builder().bucket(this.largeBucket()).key(key).build();
        PutObjectPresignRequest request = PutObjectPresignRequest.builder().signatureDuration(Duration.ofMinutes(this.signedExp())).putObjectRequest(putRequest).build();
        return this.s3Presigner.presignPutObject(request);
    }
}

