/*
 * Copyright (C) 2020-2025, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package cn.sinozg.applet.oss;

/**
 * @author xieyubin
 * @Description
 * @Copyright Copyright (c) 2025
 * @since 2025-07-20 17:42
 */
public interface OssConstants {

    /** 前缀 */
    String PREFIX = "app.oss.type";
    /** 服务商 */
    String S3 = "s3";
    String ALI = "ali";
    String MINIO = "minio";
    String QN = "qn";
    /** 关闭方法 **/
    String DM_CLOSE = "close";
    String DM_SHUTDOWN = "shutdown";
    /** bean name */
    String BN_CLIENT = "Client";
    String BN_SERVICE = "StoreService";
    /** 默认文件格式 **/
    String[] DEFAULT_EXTENSION = {"bmp", "gif", "jpg", "jpeg", "png", "pdf"};

    /** 文件大小 默认 大小 5M **/
    long MAX_FILE_SIZE = 5 * 1024 * 1024;

    /** 默认的文件名最大长度 100 **/
    int DEFAULT_FILE_NAME_LENGTH = 100;
}
