/*
 * Copyright (C) 2020-2025, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.oss.config;

import cn.sinozg.applet.common.properties.AppValue;
import cn.sinozg.applet.common.properties.OssValue;
import cn.sinozg.applet.oss.OssConstants;
import cn.sinozg.applet.oss.service.FileStoreService;
import cn.sinozg.applet.oss.service.impl.FileStoreAliServiceImpl;
import com.aliyun.oss.ClientBuilderConfiguration;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.common.auth.DefaultCredentialProvider;
import com.aliyun.oss.common.comm.SignVersion;
import jakarta.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

/**
 * @author xieyubin
 * @Description
 * @Copyright Copyright (c) 2025
 * @since 2025-07-23 10:48
 */
@Configuration
@ConditionalOnProperty(name = OssConstants.PREFIX, havingValue = OssConstants.ALI)
public class OssAliConfig {

    @Resource
    private AppValue appValue;

    @Lazy
    @Bean(name = OssConstants.ALI + OssConstants.BN_CLIENT, destroyMethod = OssConstants.DM_SHUTDOWN)
    public OSS aliClient(){
        return aliClient(appValue.getOss());
    }

    @Lazy
    @Bean(name = OssConstants.ALI + OssConstants.BN_SERVICE)
    public FileStoreService<OSS> aliStoreService(OSS aliClient){
        return new FileStoreAliServiceImpl(appValue.getOss(), aliClient);
    }

    /**
     * 阿里
     * @param oss 配置
     * @return 阿里
     */
    public static OSS aliClient (OssValue oss) {
        ClientBuilderConfiguration cbc = new ClientBuilderConfiguration();
        cbc.setSignatureVersion(SignVersion.V4);
        DefaultCredentialProvider cp = new DefaultCredentialProvider(oss.getAccessKey(), oss.getSecretKey());
        return OSSClientBuilder.create().endpoint(oss.getEndpoint())
                .credentialsProvider(cp)
                .clientConfiguration(cbc)
                .region(oss.getRegion())
                .build();
    }
}
