/*
 * Copyright (C) 2020-2025, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.oss.config;

import cn.sinozg.applet.common.properties.AppValue;
import cn.sinozg.applet.oss.OssConstants;
import cn.sinozg.applet.oss.clients.QnClient;
import cn.sinozg.applet.oss.service.FileStoreService;
import cn.sinozg.applet.oss.service.impl.FileStoreQnServiceImpl;
import jakarta.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

/**
 * @author xieyubin
 * @Description
 * @Copyright Copyright (c) 2025
 * @since 2025-07-23 10:48
 */
@Configuration
@ConditionalOnProperty(name = OssConstants.PREFIX, havingValue = OssConstants.QN)
public class OssQnConfig {

    @Resource
    private AppValue appValue;

    @Lazy
    @Bean(name = OssConstants.QN + OssConstants.BN_CLIENT, destroyMethod = OssConstants.DM_CLOSE)
    public QnClient qnClient(){
        return new QnClient(appValue.getOss());
    }

    @Lazy
    @Bean(name = OssConstants.QN + OssConstants.BN_SERVICE)
    public FileStoreService<QnClient> aliStoreService(QnClient qnClient){
        return new FileStoreQnServiceImpl(appValue.getOss(), qnClient);
    }
}
