/*
 * Copyright (C) 2020-2025, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package cn.sinozg.applet.oss.model;

import cn.sinozg.applet.common.utils.PojoUtil;
import cn.sinozg.applet.oss.OssConstants;
import io.swagger.v3.oas.annotations.media.Schema;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * @author xieyubin
 * @Description
 * @Copyright Copyright (c) 2025
 * @since 2025-07-20 17:36
 */
public class FileUploadParams {

    @Schema(description = "文件")
    private MultipartFile file;

    @Schema(description = "允许的后缀")
    private String[] allowedExtension;

    @Schema(description = "是否计算sha256")
    private boolean sha;

    @Schema(description = "业务ID")
    private String bizId;

    @Schema(description = "文件最大")
    private long maxSize;

    @Schema(description = "自己设置 后缀")
    private List<String> extension;

    @Schema(description = "桶名称，不传入则取配置里的")
    private String bucketName;

    @Schema(description = "是否让key和ID 一样，简单化")
    private boolean keyEqId;

    @Schema(description = "直接显示，即key后面是不是带后缀")
    private boolean show;

    @Schema(description = "key前面的前缀，用于分层、隔离等")
    private String keyPrefix;


    public FileUploadParams(MultipartFile file, String bizId) {
        this(file, bizId,false);
    }

    public FileUploadParams(MultipartFile file, String bizId, boolean sha) {
        this(file, (String[]) null, sha);
        this.bizId = bizId;
    }

    public FileUploadParams(MultipartFile file, String[] allowedExtension, boolean sha) {
        this.file = file;
        this.allowedExtension = allowedExtension;
        this.sha = sha;
        this.maxSize = OssConstants.MAX_FILE_SIZE;
        this.keyEqId = false;
        this.show = false;
    }


    public MultipartFile getFile() {
        return file;
    }

    public void setFile(MultipartFile file) {
        this.file = file;
    }

    public void setAllowedExtension(String[] allowedExtension) {
        this.allowedExtension = allowedExtension;
    }

    public String[] getAllowedExtension() {
        if (CollectionUtils.isEmpty(getExtension())) {
            return OssConstants.DEFAULT_EXTENSION;
        }
        return PojoUtil.toArray(getExtension(), String.class);
    }

    public boolean isSha() {
        return sha;
    }

    public void setSha(boolean sha) {
        this.sha = sha;
    }

    public String getBizId() {
        return bizId;
    }

    public void setBizId(String bizId) {
        this.bizId = bizId;
    }

    public long getMaxSize() {
        return maxSize;
    }

    public void setMaxSize(long maxSize) {
        this.maxSize = maxSize;
    }

    public List<String> getExtension() {
        return extension;
    }

    public void setExtension(List<String> extension) {
        this.extension = extension;
    }

    public boolean isShow() {
        return show;
    }

    public void setShow(boolean show) {
        this.show = show;
    }

    public String getBucketName() {
        return bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getKeyPrefix() {
        return keyPrefix;
    }

    public void setKeyPrefix(String keyPrefix) {
        this.keyPrefix = keyPrefix;
    }

    public boolean isKeyEqId() {
        return keyEqId;
    }

    public void setKeyEqId(boolean keyEqId) {
        this.keyEqId = keyEqId;
    }
}
