/*
 * Copyright (C) 2020-2025, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.oss.config;

import cn.sinozg.applet.common.properties.AppValue;
import cn.sinozg.applet.common.properties.OssValue;
import cn.sinozg.applet.oss.OssConstants;
import cn.sinozg.applet.oss.service.FileStoreService;
import cn.sinozg.applet.oss.service.impl.FileStoreMinioServiceImpl;
import io.minio.MinioClient;
import jakarta.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

/**
 * @author xieyubin
 * @Description
 * @Copyright Copyright (c) 2025
 * @since 2025-07-23 10:48
 */
@Configuration
@ConditionalOnProperty(name = OssConstants.PREFIX, havingValue = OssConstants.MINIO)
public class OssMinioConfig {

    @Resource
    private AppValue appValue;

    @Lazy
    @Bean(name = OssConstants.MINIO + OssConstants.BN_CLIENT, destroyMethod = OssConstants.DM_CLOSE)
    public MinioClient minioClient(){
        return minioClient(appValue.getOss());
    }

    @Lazy
    @Bean(name = OssConstants.MINIO + OssConstants.BN_SERVICE)
    public FileStoreService<MinioClient> minioStoreService(MinioClient minioClient){
        return new FileStoreMinioServiceImpl(appValue.getOss(), minioClient);
    }

    /**
     * MINIO客户端
     * @param oss 配置
     * @return MINIO客户端
     */
    public static MinioClient minioClient (OssValue oss){
        return MinioClient.builder()
                .endpoint(oss.getEndpoint())
                .credentials(oss.getAccessKey(), oss.getSecretKey())
                .build();
    }
}
