/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.oss.config;

import cn.sinozg.applet.common.properties.AppValue;
import cn.sinozg.applet.common.properties.OssValue;
import cn.sinozg.applet.oss.service.FileStoreService;
import cn.sinozg.applet.oss.service.impl.FileStoreAliServiceImpl;
import com.aliyun.oss.ClientBuilderConfiguration;
import com.aliyun.oss.ClientConfiguration;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.common.auth.CredentialsProvider;
import com.aliyun.oss.common.auth.DefaultCredentialProvider;
import com.aliyun.oss.common.comm.SignVersion;
import jakarta.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration
@ConditionalOnProperty(name={"app.oss.type"}, havingValue="ali")
public class OssAliConfig {
    @Resource
    private AppValue appValue;

    @Lazy
    @Bean(name={"aliClient"}, destroyMethod="shutdown")
    public OSS aliClient() {
        return OssAliConfig.aliClient(this.appValue.getOss());
    }

    @Lazy
    @Bean(name={"aliStoreService"})
    public FileStoreService<OSS> aliStoreService(OSS aliClient) {
        return new FileStoreAliServiceImpl(this.appValue.getOss(), aliClient);
    }

    public static OSS aliClient(OssValue oss) {
        ClientBuilderConfiguration cbc = new ClientBuilderConfiguration();
        cbc.setSignatureVersion(SignVersion.V4);
        DefaultCredentialProvider cp = new DefaultCredentialProvider(oss.getAccessKey(), oss.getSecretKey());
        return OSSClientBuilder.create().endpoint(oss.getEndpoint()).credentialsProvider((CredentialsProvider)cp).clientConfiguration((ClientConfiguration)cbc).region(oss.getRegion()).build();
    }
}

