/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.oss.config;

import cn.sinozg.applet.common.properties.AppValue;
import cn.sinozg.applet.oss.clients.QnClient;
import cn.sinozg.applet.oss.service.FileStoreService;
import cn.sinozg.applet.oss.service.impl.FileStoreQnServiceImpl;
import jakarta.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration
@ConditionalOnProperty(name={"app.oss.type"}, havingValue="qn")
public class OssQnConfig {
    @Resource
    private AppValue appValue;

    @Lazy
    @Bean(name={"qnClient"}, destroyMethod="close")
    public QnClient qnClient() {
        return new QnClient(this.appValue.getOss());
    }

    @Lazy
    @Bean(name={"qnStoreService"})
    public FileStoreService<QnClient> aliStoreService(QnClient qnClient) {
        return new FileStoreQnServiceImpl(this.appValue.getOss(), qnClient);
    }
}

