/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.oss.model;

import cn.sinozg.applet.common.utils.PojoUtil;
import cn.sinozg.applet.oss.OssConstants;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

public class FileUploadParams {
    @Schema(description="\u6587\u4ef6")
    private MultipartFile file;
    @Schema(description="\u5141\u8bb8\u7684\u540e\u7f00")
    private String[] allowedExtension;
    @Schema(description="\u662f\u5426\u8ba1\u7b97sha256")
    private boolean sha;
    @Schema(description="\u4e1a\u52a1ID")
    private String bizId;
    @Schema(description="\u6587\u4ef6\u6700\u5927")
    private long maxSize;
    @Schema(description="\u81ea\u5df1\u8bbe\u7f6e \u540e\u7f00")
    private List<String> extension;
    @Schema(description="\u6876\u540d\u79f0\uff0c\u4e0d\u4f20\u5165\u5219\u53d6\u914d\u7f6e\u91cc\u7684")
    private String bucketName;
    @Schema(description="\u662f\u5426\u8ba9key\u548cID \u4e00\u6837\uff0c\u7b80\u5355\u5316")
    private boolean keyEqId;
    @Schema(description="\u76f4\u63a5\u663e\u793a\uff0c\u5373key\u540e\u9762\u662f\u4e0d\u662f\u5e26\u540e\u7f00")
    private boolean show;
    @Schema(description="key\u524d\u9762\u7684\u524d\u7f00\uff0c\u7528\u4e8e\u5206\u5c42\u3001\u9694\u79bb\u7b49")
    private String keyPrefix;

    public FileUploadParams(MultipartFile file, String bizId) {
        this(file, bizId, false);
    }

    public FileUploadParams(MultipartFile file, String bizId, boolean sha) {
        this(file, (String[])null, sha);
        this.bizId = bizId;
    }

    public FileUploadParams(MultipartFile file, String[] allowedExtension, boolean sha) {
        this.file = file;
        this.allowedExtension = allowedExtension;
        this.sha = sha;
        this.maxSize = 0x500000L;
        this.keyEqId = false;
        this.show = false;
    }

    public MultipartFile getFile() {
        return this.file;
    }

    public void setFile(MultipartFile file) {
        this.file = file;
    }

    public void setAllowedExtension(String[] allowedExtension) {
        this.allowedExtension = allowedExtension;
    }

    public String[] getAllowedExtension() {
        if (CollectionUtils.isEmpty(this.getExtension())) {
            return OssConstants.DEFAULT_EXTENSION;
        }
        return (String[])PojoUtil.toArray(this.getExtension(), String.class);
    }

    public boolean isSha() {
        return this.sha;
    }

    public void setSha(boolean sha) {
        this.sha = sha;
    }

    public String getBizId() {
        return this.bizId;
    }

    public void setBizId(String bizId) {
        this.bizId = bizId;
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(long maxSize) {
        this.maxSize = maxSize;
    }

    public List<String> getExtension() {
        return this.extension;
    }

    public void setExtension(List<String> extension) {
        this.extension = extension;
    }

    public boolean isShow() {
        return this.show;
    }

    public void setShow(boolean show) {
        this.show = show;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getKeyPrefix() {
        return this.keyPrefix;
    }

    public void setKeyPrefix(String keyPrefix) {
        this.keyPrefix = keyPrefix;
    }

    public boolean isKeyEqId() {
        return this.keyEqId;
    }

    public void setKeyEqId(boolean keyEqId) {
        this.keyEqId = keyEqId;
    }
}

