/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.oss.service.impl;

import cn.sinozg.applet.common.properties.OssValue;
import cn.sinozg.applet.oss.service.impl.FileStoreBaseService;
import com.aliyun.oss.HttpMethod;
import com.aliyun.oss.OSS;
import com.aliyun.oss.model.DeleteObjectsRequest;
import com.aliyun.oss.model.DeleteObjectsResult;
import com.aliyun.oss.model.GeneratePresignedUrlRequest;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.PutObjectRequest;
import com.aliyun.oss.model.PutObjectResult;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileStoreAliServiceImpl
extends FileStoreBaseService<OSS> {
    private final OSS aliClient;
    private static final Logger log = LoggerFactory.getLogger(FileStoreAliServiceImpl.class);

    public FileStoreAliServiceImpl(OssValue oss, OSS client) {
        super(oss);
        this.aliClient = client;
        this.setClient(client);
    }

    @Override
    public String upload(byte[] bs, String bucketName, String key, String contentType) throws Exception {
        try (ByteArrayInputStream bis = new ByteArrayInputStream(bs);){
            PutObjectRequest request = new PutObjectRequest(bucketName, key, (InputStream)bis);
            PutObjectResult result = this.aliClient.putObject(request);
            String string = StringUtils.lowerCase((String)result.getETag());
            return string;
        }
    }

    @Override
    public String preSignedUrl(String key, boolean upload) throws Exception {
        GeneratePresignedUrlRequest request = new GeneratePresignedUrlRequest(this.largeBucket(), key);
        LocalDateTime newTime = LocalDateTime.now().plusMinutes(this.signedExp());
        request.setMethod(upload ? HttpMethod.PUT : HttpMethod.GET);
        request.setExpiration(Date.from(newTime.atZone(ZoneId.systemDefault()).toInstant()));
        URL url = this.aliClient.generatePresignedUrl(request);
        if (url != null) {
            return url.toExternalForm();
        }
        return null;
    }

    @Override
    public Collection<?> deletes(String bucketName, List<String> list) throws Exception {
        DeleteObjectsRequest params = new DeleteObjectsRequest(bucketName).withKeys(list).withEncodingType("url");
        DeleteObjectsResult result = this.aliClient.deleteObjects(params);
        return result.getDeletedObjects();
    }

    @Override
    public InputStream download(String bucketName, String key) throws Exception {
        GetObjectRequest request = new GetObjectRequest(bucketName, key);
        return this.aliClient.getObject(request).getObjectContent();
    }
}

