/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.common.utils;

import cn.sinozg.applet.common.core.model.ImportExcelResult;
import cn.sinozg.applet.common.excel.EasyExcelReadListener;
import cn.sinozg.applet.common.exception.CavException;
import cn.sinozg.applet.common.utils.DateUtil;
import cn.sinozg.applet.common.utils.DowUtil;
import cn.sinozg.applet.common.utils.FileUtil;
import cn.sinozg.applet.common.utils.PojoUtil;
import cn.sinozg.applet.common.utils.SnowFlake;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.read.builder.ExcelReaderBuilder;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.excel.write.metadata.fill.FillConfig;
import com.alibaba.excel.write.metadata.style.WriteCellStyle;
import com.alibaba.excel.write.metadata.style.WriteFont;
import com.alibaba.excel.write.style.HorizontalCellStyleStrategy;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.web.multipart.MultipartFile;

public class ExcelUtil {
    private static final Logger log = LoggerFactory.getLogger(ExcelUtil.class);

    public static <T> List<T> importExcel(MultipartFile file, Class<T> clazz) {
        return ExcelUtil.importExcel(file, f -> f, clazz).getData();
    }

    public static <T, U> ImportExcelResult<U> importExcel(MultipartFile file, Function<T, U> function, Class<T> clazz) {
        ImportExcelResult result = new ImportExcelResult();
        if (!FileUtil.judgeFile((MultipartFile)file, (String[])new String[]{".xls", ".xlsx"})) {
            throw new CavException("BIZ000100027");
        }
        EasyExcelReadListener<T, U> listener = new EasyExcelReadListener<T, U>(function, result);
        try (InputStream is = file.getInputStream();){
            ((ExcelReaderBuilder)EasyExcel.read((InputStream)is, listener).head(clazz)).sheet().doRead();
        }
        catch (Exception e) {
            log.error("\u8bfb\u53d6excel\u9519\u8bef\uff0c{}\uff0c {}", (Object)file.getOriginalFilename(), (Object)e.getMessage());
            throw new CavException("BIZ000100026");
        }
        return result;
    }

    public static <T> void exportWithTemp(HttpServletResponse response, String tempPath, List<T> exportData, Object otherInfo) {
        String fileName = StringUtils.substringAfterLast((String)tempPath, (String)"/");
        ExcelUtil.setResponse(response, fileName);
        ClassPathResource classPathResource = new ClassPathResource(tempPath);
        try (InputStream inputStream = classPathResource.getInputStream();
             ServletOutputStream os = response.getOutputStream();
             BufferedOutputStream bos = new BufferedOutputStream((OutputStream)os);
             ExcelWriter excelWriter = EasyExcel.write((OutputStream)bos).withTemplate(inputStream).build();){
            WriteSheet writeSheet = EasyExcel.writerSheet().build();
            FillConfig fillConfig = FillConfig.builder().forceNewRow(Boolean.TRUE).build();
            excelWriter.fill(exportData, fillConfig, writeSheet);
            if (otherInfo != null) {
                excelWriter.fill(otherInfo, writeSheet);
            }
            excelWriter.finish();
        }
        catch (Exception e) {
            log.error("\u6839\u636e\u6a21\u677fexcel\u6587\u4ef6\u5bfc\u51faexcel\u5931\u8d25:", (Throwable)e);
            throw new CavException("BIZ000100024");
        }
    }

    public static <T> void exportSingleFile(HttpServletResponse response, String fileName, List<T> exportData, String sheetName) {
        if (CollectionUtils.isEmpty(exportData)) {
            throw new CavException("BIZ000100025");
        }
        ExcelUtil.exportFile(fileName, PojoUtil.arrayToList((Object[])new List[]{exportData}), response, sheetName);
    }

    public static <T> void exportFile(String fileName, List<List<T>> exportData, HttpServletResponse response, String ... sheetNames) {
        if (Objects.isNull(response) || CollectionUtils.isEmpty(exportData)) {
            log.error("ExcelUtil exportFile required param can't be empty");
            throw new CavException("BIZ000100025");
        }
        ExcelUtil.setResponse(response, fileName);
        HorizontalCellStyleStrategy horizontalCellStyleStrategy = ExcelUtil.getExportDefaultStyle();
        try (ServletOutputStream os = response.getOutputStream();
             BufferedOutputStream bos = new BufferedOutputStream((OutputStream)os);
             ExcelWriter writer = ((ExcelWriterBuilder)EasyExcel.write((OutputStream)bos).registerWriteHandler((WriteHandler)horizontalCellStyleStrategy)).build();){
            for (int itemIndex = 0; itemIndex < exportData.size(); ++itemIndex) {
                List<T> list = exportData.get(itemIndex);
                Class<?> clazz = list.get(0).getClass();
                String sheetName = "sheet" + (itemIndex + 1);
                if (ArrayUtils.isNotEmpty((Object[])sheetNames) && sheetNames.length >= itemIndex) {
                    sheetName = sheetNames[itemIndex];
                }
                WriteSheet sheet = ((ExcelWriterSheetBuilder)EasyExcel.writerSheet((Integer)itemIndex, (String)sheetName).head(clazz)).build();
                writer.write(list, sheet);
            }
        }
        catch (Exception e) {
            log.error("ExcelUtil exportFile in error:", (Throwable)e);
            throw new CavException("BIZ000100024");
        }
    }

    public static void downloadExcelTemp(HttpServletResponse response, String tempName) {
        ClassPathResource classPathResource = new ClassPathResource(tempName);
        try (InputStream inputStream = classPathResource.getInputStream();){
            DowUtil.download((HttpServletResponse)response, (String)tempName, (byte[])IOUtils.toByteArray((InputStream)inputStream), null);
        }
        catch (Exception e) {
            log.error("\u4e0b\u8f7dexcel \u6a21\u7248\u9519\u8bef\uff01", (Throwable)e);
        }
    }

    private static void setResponse(HttpServletResponse response, String fileName) {
        if (StringUtils.isBlank((CharSequence)fileName)) {
            fileName = SnowFlake.genId() + ".xlsx";
        } else {
            String[] arrays = StringUtils.split((String)fileName, (String)".");
            fileName = String.format("%s(%s).%s", arrays[0], DateUtil.formatDateTime((LocalDateTime)LocalDateTime.now(), (String)"MMddHHmmssSSS"), arrays[1]);
        }
        DowUtil.setResponse((HttpServletResponse)response, (String)fileName, null);
    }

    private static HorizontalCellStyleStrategy getExportDefaultStyle() {
        WriteCellStyle headWriteCellStyle = new WriteCellStyle();
        WriteFont headWriteFont = new WriteFont();
        headWriteFont.setBold(Boolean.valueOf(true));
        headWriteCellStyle.setWriteFont(headWriteFont);
        headWriteCellStyle.setHorizontalAlignment(HorizontalAlignment.CENTER);
        WriteCellStyle contentWriteCellStyle = new WriteCellStyle();
        contentWriteCellStyle.setHorizontalAlignment(HorizontalAlignment.CENTER);
        return new HorizontalCellStyleStrategy(headWriteCellStyle, contentWriteCellStyle);
    }
}

