/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.common.excel;

import cn.sinozg.applet.common.core.model.ImportExcelResult;
import cn.sinozg.applet.common.utils.PojoUtil;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.exception.ExcelDataConvertException;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EasyExcelReadListener<T, U>
extends AnalysisEventListener<T> {
    private final Function<T, U> function;
    private final ImportExcelResult<U> result;
    private final Logger log = LoggerFactory.getLogger(EasyExcelReadListener.class);

    public EasyExcelReadListener(Function<T, U> function, ImportExcelResult<U> result) {
        this.function = function;
        this.result = result;
    }

    public void onException(Exception exception, AnalysisContext context) throws Exception {
        if (exception instanceof ExcelDataConvertException) {
            ExcelDataConvertException e = (ExcelDataConvertException)exception;
            String detail = String.format("\u7b2c%d\u884c\uff0c\u7b2c%d\u5217\u89e3\u6790\u5f02\u5e38\uff0c\u6570\u636e\u4e3a\uff1a%s", e.getRowIndex(), e.getColumnIndex(), e.getCellData().getStringValue());
            this.log.error(detail, (Throwable)e);
            PojoUtil.setBeanList(this.result, (Object)detail, ImportExcelResult::getErrorInfo, ImportExcelResult::setErrorInfo);
        }
    }

    public void invoke(T data, AnalysisContext context) {
        PojoUtil.setBeanList(this.result, this.function.apply(data), ImportExcelResult::getData, ImportExcelResult::setData);
    }

    public void doAfterAllAnalysed(AnalysisContext context) {
    }
}

