package cn.sinozg.applet.common.excel;

import ai.chat2db.excel.converters.Converter;
import ai.chat2db.excel.enums.CellDataTypeEnum;
import ai.chat2db.excel.metadata.GlobalConfiguration;
import ai.chat2db.excel.metadata.data.WriteCellData;
import ai.chat2db.excel.metadata.property.ExcelContentProperty;
import cn.sinozg.applet.common.annotation.DictTrans;
import cn.sinozg.applet.common.annotation.PicUrl;
import cn.sinozg.applet.common.utils.DictTransUtil;
import cn.sinozg.applet.common.utils.StringUtil;

import java.lang.reflect.Field;

/**
* 导出转移 使用方式为
 * <pre> {@code
 * @ExcelProperty(converter = ExcelWriteConverter.class)
 * }</pre>
* @Author: xyb
* @Description:
* @Date: 2023-04-30 上午 01:18
**/
public class ExcelWriteConverter implements Converter<String> {

    @Override
    public Class<?> supportJavaTypeKey() {
        return String.class;
    }

    @Override
    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }


    /**
     * 读取转化
     * @param value               Java Data.NotNull.
     * @param contentProperty     Content property.NotNull
     * @param globalConfiguration Global configuration.NotNull.
     * @return 要写入excel的值
     */
    @Override
    public WriteCellData<?> convertToExcelData(String value, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) {
        String targetValue = value;
        Field field = contentProperty.getField();
        // 标准数据转换
        DictTrans dict = field.getAnnotation(DictTrans.class);
        if (dict != null) {
            targetValue = DictTransUtil.dictTrans(value, dict);
        }
        // 图片
        PicUrl pic = field.getAnnotation(PicUrl.class);
        if (pic != null) {
            targetValue = StringUtil.showUrl(value);
        }
        assert targetValue != null;
        return new WriteCellData<>(targetValue);
    }
}
