/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.common.core.model;


import ai.chat2db.excel.write.builder.ExcelWriterSheetBuilder;

import java.util.List;
import java.util.function.Consumer;

/**
 * 导入数据
 * @author xyb
 * @Description
 * @Copyright Copyright (c) 2024
 * @since 2024-05-06 17:45
 */
public class ExportData<T> {

    /** sheet 自定义操作 header等 */
    private Consumer<ExcelWriterSheetBuilder> sheetConsumer;
    /** sheet 数据 */
    private List<T> sheetData;
    /** sheet NAME */
    private String sheetName;
    /** 国际化导出 */
    private boolean i18nHeader;

    public ExportData(){

    }

    public ExportData(String sheetName, List<T> sheetData) {
        this.sheetName = sheetName;
        this.sheetData = sheetData;
    }


    public Consumer<ExcelWriterSheetBuilder> getSheetConsumer() {
        return sheetConsumer;
    }

    public void setSheetConsumer(Consumer<ExcelWriterSheetBuilder> sheetConsumer) {
        this.sheetConsumer = sheetConsumer;
    }

    public List<T> getSheetData() {
        return sheetData;
    }

    public void setSheetData(List<T> sheetData) {
        this.sheetData = sheetData;
    }

    public String getSheetName() {
        return sheetName;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    public boolean isI18nHeader() {
        return i18nHeader;
    }

    public void setI18nHeader(boolean i18nHeader) {
        this.i18nHeader = i18nHeader;
    }
}
