/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.common.core.model;

import ai.chat2db.excel.read.builder.ExcelReaderSheetBuilder;
import cn.sinozg.applet.common.utils.PojoUtil;
import org.springframework.web.multipart.MultipartFile;

import java.util.function.Consumer;
import java.util.function.Function;

/**
 * 封装导入 参数
 * @Author: xyb
 * @Description:
 * @Date: 2025-03-07 下午 02:42
 **/
public class ImportExcelParams<T, U> {
    /** 导入文件 */
    private MultipartFile file;
    /** 导入的实体bean 转为db的entity */
    private Function<T, U> function;
    /** 实体对象类型 */
    private Class<T> clazz;
    /** 函数处理 */
    private Consumer<ExcelReaderSheetBuilder> excel;
    /** 读取的sheet页 */
    private Integer sheetNo;

    public ImportExcelParams (MultipartFile file, Class<T> clazz) {
        this(file, PojoUtil::cast, e -> e.headRowNumber(0), clazz);
    }

    public ImportExcelParams (MultipartFile file, Function<T, U> function, Consumer<ExcelReaderSheetBuilder> excel, Class<T> clazz) {
        this.file = file;
        this.excel = excel;
        this.function = function;
        this.clazz = clazz;
    }

    public MultipartFile getFile() {
        return file;
    }

    public void setFile(MultipartFile file) {
        this.file = file;
    }

    public Function<T, U> getFunction() {
        return function;
    }

    public void setFunction(Function<T, U> function) {
        this.function = function;
    }

    public Class<T> getClazz() {
        return clazz;
    }

    public void setClazz(Class<T> clazz) {
        this.clazz = clazz;
    }

    public Consumer<ExcelReaderSheetBuilder> getExcel() {
        return excel;
    }

    public void setExcel(Consumer<ExcelReaderSheetBuilder> excel) {
        this.excel = excel;
    }

    public Integer getSheetNo() {
        return sheetNo;
    }

    public void setSheetNo(Integer sheetNo) {
        this.sheetNo = sheetNo;
    }
}