package cn.sinozg.applet.common.sa;

import cn.dev33.satoken.stp.StpInterface;
import cn.sinozg.applet.common.utils.UserUtil;
import org.springframework.stereotype.Component;

import java.util.List;

/**
* 接口选取
* @Author: xyb
* @Description:
* @Date: 2022-11-14 下午 10:19
**/
@Component
public class StpInterfaceImpl implements StpInterface {

    /**
     * 获取权限集合
     * @param loginId 登录id
     * @param loginType 登录类型
     * @return 权限集合
     */
    @Override
    public List<String> getPermissionList(Object loginId, String loginType) {
        return UserUtil.userPermission();
    }

    /**
     * 获取角色集合
     * @param loginId 登录id
     * @param loginType 登录类型
     * @return 角色集合
     */
    @Override
    public List<String> getRoleList(Object loginId, String loginType) {
        return UserUtil.userRole();
    }
}
