package cn.sinozg.applet.common.handler;

import cn.dev33.satoken.exception.NotLoginException;
import cn.dev33.satoken.exception.NotPermissionException;
import cn.dev33.satoken.exception.NotRoleException;
import cn.dev33.satoken.exception.SaTokenException;
import cn.sinozg.applet.common.constant.BaseConstants;
import cn.sinozg.applet.common.utils.MsgUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestControllerAdvice;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;

/**
 * sa 异常全局拦截器
 * @author xieyubin
 * @Description
 * @Copyright Copyright (c) 2024
 * @since 2024-01-05 17:34
 */
@RestControllerAdvice
@Order(Ordered.HIGHEST_PRECEDENCE)
public class GlobalExceptionHandlerSa {

    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandlerSa.class);
    /**
     * 鉴权异常处理
     * @param request HttpServletRequest
     * @param e 异常
     */
    @ResponseBody
    @ExceptionHandler(NotLoginException.class)
    public void nonLoginException(HttpServletRequest request, HttpServletResponse response, NotLoginException e) {
        log.error("未授权！！");
        String errorMsg = e.getMessage();
        if (StringUtils.isNotEmpty(errorMsg)) {
            errorMsg = StringUtils.substringBefore(errorMsg, "：");
        }
        MsgUtil.httpError(response, request, e, HttpStatus.UNAUTHORIZED, BaseConstants.DEFAULT_CODE, errorMsg);
    }

    /**
     * 权限相关异常处理
     * @param request HttpServletRequest
     * @param response HttpServletResponse
     * @param e 异常
     */
    @ResponseBody
    @ExceptionHandler(value = {NotPermissionException.class, NotRoleException.class})
    public void forbidden(HttpServletRequest request, HttpServletResponse response, SaTokenException e) {
        log.error("没有权限！！");
        String errorMsg = e.getMessage();
        MsgUtil.httpError(response, request, e, HttpStatus.FORBIDDEN, BaseConstants.DEFAULT_CODE, errorMsg);
    }
}
