package cn.sinozg.applet.common.sa;

import cn.dev33.satoken.annotation.SaIgnore;
import cn.dev33.satoken.exception.StopMatchException;
import cn.dev33.satoken.stp.StpUtil;
import cn.dev33.satoken.strategy.SaStrategy;
import cn.sinozg.applet.common.constant.BaseConstants;
import cn.sinozg.applet.common.utils.SpringUtil;
import org.jetbrains.annotations.NotNull;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.HandlerInterceptor;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.reflect.Method;

/**
 * Sa-Token 综合拦截器，提供注解鉴权和路由拦截鉴权能力
 * 重写，保证可以拿到具体异常 由全局异常处理器去处理所有的异常
 * 
 * @author click33
 * @since 1.31.0
 */
public class SaInterceptor implements HandlerInterceptor {

	/**
	 * 是否打开注解鉴权，配置为 true 时注解鉴权才会生效，配置为 false 时，即使写了注解也不会进行鉴权
	 */
	public boolean isAnnotation = true;


	/**
	 * 创建一个 Sa-Token 综合拦截器，默认带有注解鉴权能力 
	 */
	public SaInterceptor() {
	}


	/**
	 * 设置是否打开注解鉴权：配置为 true 时注解鉴权才会生效，配置为 false 时，即使写了注解也不会进行鉴权
	 * @param isAnnotation /
	 * @return 对象自身
	 */
	public SaInterceptor isAnnotation(boolean isAnnotation) {
		this.isAnnotation = isAnnotation;
		return this;
	}

	/**
	 * 每次请求之前触发的方法 
	 */
	@Override
	public boolean preHandle(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull Object handler) throws Exception {
		try {
			// 这里必须确保 handler 是 HandlerMethod 类型时，才能进行注解鉴权
			if(isAnnotation && handler instanceof HandlerMethod) {
				// 获取此请求对应的 Method 处理函数 
				Method method = ((HandlerMethod) handler).getMethod();
				// 如果此 Method 或其所属 Class 标注了 @SaIgnore，则忽略掉鉴权
				if(SaStrategy.instance.isAnnotationPresent.apply(method, SaIgnore.class)) {
					// 注意这里直接就退出整个鉴权了，最底部的 auth.run() 路由拦截鉴权也被跳出了
					return true;
				}
				// 执行注解鉴权
				SaStrategy.instance.checkMethodAnnotation.accept(method);
			}
			// Auth 路由拦截鉴权校验
			StpUtil.checkLogin();
		} catch (StopMatchException ignored) {
		} catch (Exception e) {
			HandlerExceptionResolver resolver = SpringUtil.getBean(BaseConstants.EXCEPTION_RESOLVER);
			if (resolver != null) {
				resolver.resolveException(request, response, null, e);
			}
			return false;
		}
		// 通过验证 
		return true;
	}

}
