package cn.sinozg.applet.common.service.impl;

import cn.dev33.satoken.stp.StpUtil;
import cn.sinozg.applet.common.sa.SaInterceptor;
import cn.sinozg.applet.common.service.FrameworkAuthService;
import cn.sinozg.applet.common.utils.PojoUtil;
import cn.sinozg.applet.common.utils.TirsciUtil;
import org.springframework.stereotype.Service;
import org.springframework.web.servlet.HandlerInterceptor;

/**
 * 实现鉴权 拦截器
 * @author xieyubin
 * @Description
 * @Copyright Copyright (c) 2024
 * @since 2024-01-05 17:30
 */
@Service
public class SaFrameworkAuthServiceImpl implements FrameworkAuthService {
    @Override
    public String token() {
        return TirsciUtil.tryCatch(StpUtil::getTokenValue);
    }

    @Override
    public String tokenWithException() {
        return StpUtil.getTokenValue();
    }

    @Override
    public String loginId() {
        return PojoUtil.cast(TirsciUtil.tryCatch(StpUtil::getLoginId));
    }

    @Override
    public String loginIdByToken(String token) {
        Object uid = StpUtil.getLoginIdByToken(token);
        return PojoUtil.cast(uid);
    }

    @Override
    public String tokenById(String id) {
        return StpUtil.getTokenValueByLoginId(id);
    }

    @Override
    public void login(String id) {
        StpUtil.login(id);
    }

    @Override
    public void logout(String tokenId) {
        StpUtil.logout(tokenId);
    }

    @Override
    public void kickOutByTokenValue(String tokenId) {
        StpUtil.kickoutByTokenValue(tokenId);
    }

    @Override
    public long tokenTimeOut() {
        return StpUtil.getTokenTimeout();
    }

    @Override
    public HandlerInterceptor authInterceptor() {
        return new SaInterceptor();
    }
}
