/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.common.service.impl;

import cn.dev33.satoken.stp.StpUtil;
import cn.sinozg.applet.common.sa.SaInterceptor;
import cn.sinozg.applet.common.service.FrameworkAuthService;
import cn.sinozg.applet.common.utils.PojoUtil;
import cn.sinozg.applet.common.utils.TirsciUtil;
import org.springframework.stereotype.Service;
import org.springframework.web.servlet.HandlerInterceptor;

/**
 * 实现鉴权 拦截器
 * @author xieyubin
 * @Description
 * @Copyright Copyright (c) 2024
 * @since 2024-01-05 17:30
 */
@Service
public class SaFrameworkAuthServiceImpl implements FrameworkAuthService {
    @Override
    public String token() {
        return TirsciUtil.tryCatch(StpUtil::getTokenValue);
    }

    @Override
    public String tokenWithException() {
        return StpUtil.getTokenValue();
    }

    @Override
    public String loginId() {
        return PojoUtil.cast(TirsciUtil.tryCatch(StpUtil::getLoginId));
    }

    @Override
    public String loginIdByToken(String token) {
        Object uid = StpUtil.getLoginIdByToken(token);
        return PojoUtil.cast(uid);
    }

    @Override
    public String tokenById(String id) {
        return StpUtil.getTokenValueByLoginId(id);
    }

    @Override
    public void login(String id) {
        StpUtil.login(id);
    }

    @Override
    public void logout(String tokenId) {
        StpUtil.logout(tokenId);
    }

    @Override
    public void kickOutByTokenValue(String tokenId) {
        StpUtil.kickoutByTokenValue(tokenId);
    }

    @Override
    public long tokenTimeOut() {
        return StpUtil.getTokenTimeout();
    }

    @Override
    public HandlerInterceptor authInterceptor() {
        return new SaInterceptor();
    }
}
