/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.sa.plugin;

import cn.dev33.satoken.dao.auto.SaTokenDaoBySessionFollowObject;
import cn.dev33.satoken.util.SaFoxUtil;
import cn.sinozg.applet.common.utils.RedisUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;

class SaRedisJackson
implements SaTokenDaoBySessionFollowObject {
    SaRedisJackson() {
    }

    public String get(String key) {
        return (String)RedisUtil.getCacheObject((String)key);
    }

    public void set(String key, String value, long timeout) {
        this.setObject(key, value, timeout);
    }

    public void update(String key, String value) {
        this.updateObject(key, value);
    }

    public void delete(String key) {
        RedisUtil.deleteObject((String)key);
    }

    public long getTimeout(String key) {
        return RedisUtil.objExpireTime((String)key);
    }

    public void updateTimeout(String key, long timeout) {
        this.updateObjectTimeout(key, timeout);
    }

    public Object getObject(String key) {
        return RedisUtil.getCacheObject((String)key);
    }

    public <T> T getObject(String key, Class<T> classType) {
        return (T)RedisUtil.getCacheObject((String)key);
    }

    public void setObject(String key, Object object, long timeout) {
        if (timeout == 0L || timeout <= -2L) {
            return;
        }
        RedisUtil.setCacheObject((String)key, (Object)object, (long)timeout);
    }

    public void updateObject(String key, Object object) {
        long expire = this.getObjectTimeout(key);
        if (expire == -2L) {
            return;
        }
        this.setObject(key, object, expire);
    }

    public void deleteObject(String key) {
        RedisUtil.deleteObject((String)key);
    }

    public long getObjectTimeout(String key) {
        return RedisUtil.objExpireTime((String)key);
    }

    public void updateObjectTimeout(String key, long timeout) {
        if (timeout == -1L) {
            long expire = this.getTimeout(key);
            if (expire != -1L) {
                this.setObject(key, this.getObject(key), timeout);
            }
            return;
        }
        RedisUtil.expire((String)key, (long)timeout, (TimeUnit)TimeUnit.SECONDS);
    }

    public List<String> searchData(String prefix, String keyword, int start, int size, boolean sortType) {
        String pattern = prefix + "*";
        if (StringUtils.isNotEmpty((CharSequence)keyword)) {
            pattern = pattern + keyword + "*";
        }
        Collection keys = RedisUtil.keys((String)pattern);
        ArrayList list = new ArrayList(keys);
        return SaFoxUtil.searchList(list, (int)start, (int)size, (boolean)sortType);
    }
}

